package w83b.w83bOperacionesPaso.w83bHistoricos;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bHistoricosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bOperacionesPaso.w83bResultados.W83bTablaCuadroResultadosExcelAction;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidadesN38API;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bCrearResultSexoHistAction extends Q70ActionPasoOP{
	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}
	

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bHistResultadosSexo.xls";
		InputStream inputStream = W83bTablaCuadroResultadosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
              
        HSSFCellStyle negritaBordeArriba = this.negritaBordeArriba(wb);
        
        HSSFCellStyle normalCentrado8Justif = this.normalCentrado8Justif(wb);
        HSSFCellStyle normal = this.normal(wb);
        HSSFCellStyle normalCentradoSinBordes = this.normalCentradoSinBordes(wb);
        
        List datos = (ArrayList)contexto.get("w83bResultadoHistorico");
        
        W83bHistoricosBean criterios = (W83bHistoricosBean)datos.get(0); 
               
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        String provincia = W83bUtilidadesN38API.elegirProvinciaDelegacion(usuario.getPerfilXLNets());       
         
        StringBuffer tituloImagenEu = new StringBuffer();
        StringBuffer tituloImagenEs = new StringBuffer();
        
        tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_eu",idioma));
        tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloImagenInforme_es",idioma));
        
        HSSFRow laRow = sheet.getRow((short)4); 
        HSSFCell cell = laRow.getCell((short)6);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = laRow.getCell((short)10); 
        cell.setCellValue(tituloImagenEs.toString());
        
        tituloImagenEu = new StringBuffer();
        tituloImagenEs = new StringBuffer();
        if(W83bClsConstantes.CONSTANTE_SERVICIOS_CENTRALES.equals(provincia)){
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_es",idioma));
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.direccionTrabajo_eu",idioma));
        	
        }
        else if(W83bClsConstantes.CONSTANTE_GIPUZKOA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionGuipuzcoa_es",idioma));
        }
        else if(W83bClsConstantes.CONSTANTE_ALAVA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_eu",idioma));
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionAlava_es",idioma));
        }else if(W83bClsConstantes.CONSTANTE_BIZKAIA.equals(provincia)){
        	tituloImagenEu.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_eu",idioma));        	
        	tituloImagenEs.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.delegacionBizkaia_es",idioma));        	
        }
                
        laRow = sheet.getRow((short)6); 
        cell = laRow.getCell((short)6);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = laRow.getCell((short)10); 
        cell.setCellValue(tituloImagenEs.toString());
        
        laRow = sheet.getRow((short)9);                    
        cell = laRow.getCell((short)0);                    
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.resultSexoHist").toUpperCase());  
        
        laRow = sheet.getRow((short)10); 
        cell = laRow.getCell((short)0);
        
        if (criterios.getTerritorio()== null || "".equals(criterios.getTerritorio()) || "null".equals(criterios.getTerritorio())){
        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.resultados.comautvascaentero",idioma)+" - "+criterios.getMes()+"/"+criterios.getAnyo());
        }
        else{
        	cell.setCellValue(criterios.getDescTerritorio().toUpperCase()+" - "+criterios.getMes()+"/"+criterios.getAnyo());
        }
        
        cell.setCellStyle(normalCentradoSinBordes);
        
        laRow = sheet.getRow((short)12); 
        cell = laRow.getCell((short)2);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.trabajadores").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.electores").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);

        cell = laRow.getCell((short)11);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.candidatos").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)15);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.resultados.representantes").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        laRow = sheet.getRow((short)13); 
        cell = laRow.getCell((short)1);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.t").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);

        cell = laRow.getCell((short)2);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.hombres").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)3);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.mujeres").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)4);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.noConsta").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)5);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.total").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)7);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.hombres").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)8);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.mujeres").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)9);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.historicos.noConsta").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)10);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.total").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)11);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.hombres").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)12);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.mujeres").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)14);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.total").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)15);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.hombres").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)16);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.mujeres").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        cell = laRow.getCell((short)17);
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.total").toUpperCase());
        cell.setCellStyle(normalCentrado8Justif);
        
        
        W83bHistoricosBean elDato = new W83bHistoricosBean();
      
        int fila = 14;
        
        int trabajadoresH =0;
        int trabajadoresM =0;
        int trabajadoresN =0;
        int totTrabajadores =0;
        int electoresH =0;
        int electoresM =0;
        int electoresN =0;
        int totElectores =0;
        int candidatosH =0;
        int candidatosM =0;
        int totCandidatos =0;
        int delegadosH =0;
        int delegadosM =0;
        int totDelegados =0;
        
        for (int i=0;i<datos.size();i++){
        	 elDato = (W83bHistoricosBean)datos.get(i);
        
        	 laRow = sheet.createRow((short)fila); 
    		 cell = laRow.createCell((short)1);
    		 cell.setCellValue(elDato.getDescTerritorio());
    		 cell = laRow.createCell((short)2);
    		 cell.setCellValue(numero(elDato.getTrabajadoresH()));
    		 cell.setCellStyle(normal);
    		 trabajadoresH = trabajadoresH+numero(elDato.getTrabajadoresH());
    		 cell = laRow.createCell((short)3);
    		 cell.setCellValue(numero(elDato.getTrabajadoresM()));
    		 cell.setCellStyle(normal);
    		 trabajadoresM = trabajadoresM+numero(elDato.getTrabajadoresM());
    		 cell = laRow.createCell((short)4);
    		 cell.setCellValue(numero(elDato.getTrabajadoresN()));
    		 cell.setCellStyle(normal);
    		 trabajadoresN = trabajadoresN+numero(elDato.getTrabajadoresN());
    		 sheet.addMergedRegion(new Region((short)fila,Short.parseShort("5"),(short)fila,Short.parseShort("6")));//NOPMD
    		 cell = laRow.createCell((short)5);
    		 cell.setCellValue(numero(elDato.getTotTrabajadores()));
    		 cell.setCellStyle(normal);
    		 cell = laRow.createCell((short)6);
    		 cell.setCellStyle(normal);
    		 totTrabajadores = totTrabajadores+numero(elDato.getTotTrabajadores());
    		 cell = laRow.createCell((short)7);
    		 cell.setCellValue(numero(elDato.getElectoresH()));
    		 cell.setCellStyle(normal);
    		 electoresH = electoresH+numero(elDato.getElectoresH());
    		 cell = laRow.createCell((short)8);
    		 cell.setCellValue(numero(elDato.getElectoresM()));
    		 cell.setCellStyle(normal);
    		 electoresM = electoresM+numero(elDato.getElectoresM());
    		 cell = laRow.createCell((short)9);
    		 cell.setCellValue(numero(elDato.getElectoresN()));
    		 cell.setCellStyle(normal);
    		 electoresN = electoresN+numero(elDato.getElectoresN());
    		 cell = laRow.createCell((short)10);
    		 cell.setCellValue(numero(elDato.getTotElectores()));
    		 cell.setCellStyle(normal);
    		 totElectores = totElectores+numero(elDato.getTotElectores());
    		 cell = laRow.createCell((short)11);
    		 cell.setCellValue(numero(elDato.getCandidatosH()));
    		 cell.setCellStyle(normal);
    		 candidatosH = candidatosH+numero(elDato.getCandidatosH());
    		 sheet.addMergedRegion(new Region((short)fila,Short.parseShort("12"),(short)fila,Short.parseShort("13")));//NOPMD
    		 cell = laRow.createCell((short)12);
    		 cell.setCellValue(numero(elDato.getCandidatosM()));
    		 cell.setCellStyle(normal);
    		 cell = laRow.createCell((short)13);
    		 cell.setCellStyle(normal);
    		 candidatosM = candidatosM+numero(elDato.getCandidatosM());
    		 cell = laRow.createCell((short)14);
    		 cell.setCellValue(numero(elDato.getTotCandidatos()));
    		 cell.setCellStyle(normal);
    		 totCandidatos = totCandidatos+numero(elDato.getTotCandidatos());
    		 cell = laRow.createCell((short)15);
    		 cell.setCellValue(numero(elDato.getDelegadosH()));
    		 cell.setCellStyle(normal);
    		 delegadosH = delegadosH+numero(elDato.getDelegadosH());
    		 cell = laRow.createCell((short)16);
    		 cell.setCellValue(numero(elDato.getDelegadosM()));
    		 cell.setCellStyle(normal);
    		 delegadosM = delegadosM+numero(elDato.getDelegadosM());
    		 cell = laRow.createCell((short)17);
    		 cell.setCellValue(numero(elDato.getTotDel()));
    		 cell.setCellStyle(normal);
    		 totDelegados = totDelegados+numero(elDato.getTotDel());
    		 
    		 fila++;
        }
            
         laRow = sheet.createRow((short)fila+1); 
		 cell = laRow.createCell((short)1);
		 cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.total").toUpperCase());
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)2);
		 cell.setCellValue(trabajadoresH);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)3);
		 cell.setCellValue(trabajadoresM);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)4);
		 cell.setCellValue(trabajadoresN);
		 cell.setCellStyle(negritaBordeArriba);
		 sheet.addMergedRegion(new Region((short)fila+1,Short.parseShort("5"),(short)fila+1,Short.parseShort("6")));//NOPMD
		 cell = laRow.createCell((short)5);
		 cell.setCellValue(totTrabajadores);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)6);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)7);
		 cell.setCellValue(electoresH);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)8);
		 cell.setCellValue(electoresM);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)9);
		 cell.setCellValue(electoresN);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)10);
		 cell.setCellValue(totElectores);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)11);
		 cell.setCellValue(candidatosH);
		 cell.setCellStyle(negritaBordeArriba);
		 sheet.addMergedRegion(new Region((short)fila+1,Short.parseShort("12"),(short)fila+1,Short.parseShort("13")));//NOPMD
		 cell = laRow.createCell((short)12);
		 cell.setCellValue(candidatosM);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)13);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)14);
		 cell.setCellValue(totCandidatos);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)15);
		 cell.setCellValue(delegadosH);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)16);
		 cell.setCellValue(delegadosM);
		 cell.setCellStyle(negritaBordeArriba);
		 cell = laRow.createCell((short)17);
		 cell.setCellValue(totDelegados);
		 cell.setCellStyle(negritaBordeArriba);
        
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoResultadosSexoHistorico.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	
	
	private HSSFCellStyle normal(HSSFWorkbook wb){
		HSSFCellStyle normal =  wb.createCellStyle();
		
		normal = wb.createCellStyle();// Estilo
		
		normal.setAlignment(HSSFCellStyle.ALIGN_RIGHT);	
		normal.setDataFormat((short)3);
		return normal;
		
	}

	private HSSFCellStyle normalCentrado8Justif(HSSFWorkbook wb){
		HSSFCellStyle normalCentrado8Justif =  wb.createCellStyle();		
		normalCentrado8Justif = wb.createCellStyle();// Estilo
		normalCentrado8Justif.setAlignment(HSSFCellStyle.ALIGN_JUSTIFY);
		normalCentrado8Justif.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
		normalCentrado8Justif.setBorderTop(HSSFCellStyle.BORDER_THIN);
		normalCentrado8Justif.setBorderBottom(HSSFCellStyle.BORDER_THIN);
		normalCentrado8Justif.setBorderLeft(HSSFCellStyle.BORDER_THIN);
		normalCentrado8Justif.setBorderRight(HSSFCellStyle.BORDER_THIN);
		HSSFFont fuente2 = this.negrita(wb);
		fuente2.setFontHeight((short)160);
		normalCentrado8Justif.setFont(fuente2);
		return normalCentrado8Justif;
		
	}
	
	private HSSFCellStyle normalCentradoSinBordes(HSSFWorkbook wb){
		HSSFCellStyle normal =  wb.createCellStyle();		
		normal = wb.createCellStyle();// Estilo
		normal.setAlignment(HSSFCellStyle.ALIGN_CENTER_SELECTION);	
		normal.setFont(this.negrita(wb));
		return normal;
		
	}
	
	private HSSFCellStyle negritaBordeArriba(HSSFWorkbook wb){
		HSSFCellStyle negritaBordeArriba =  wb.createCellStyle();
		
		negritaBordeArriba = wb.createCellStyle();// Estilo
		negritaBordeArriba.setBorderTop(HSSFCellStyle.BORDER_THIN);
		negritaBordeArriba.setAlignment(HSSFCellStyle.ALIGN_RIGHT);	
		negritaBordeArriba.setDataFormat((short)3);	
		negritaBordeArriba.setFont(this.negrita(wb));
		return negritaBordeArriba;
		
	}
	
	private HSSFFont negrita (HSSFWorkbook wb){
		
		HSSFFont fuente = wb.createFont();
		fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
		
		return fuente;
		
	}
	
	private int numero(String num){
	
		Integer n = new Integer(num);
		return n.intValue();
	}

}